<?php
/**
 * Register styles, scripts
 */
function automatic_theme_styles() {
	return array(
		'bootstrap'        		=> AUTOMATIC_DIR_URI . '/assets/css/bootstrap.css',
		'awesome'        		=> AUTOMATIC_DIR_URI . '/assets/css/font-awesome.min.css',
		'pe-icon'        		=> AUTOMATIC_DIR_URI . '/assets/css/Pe-icon-7-stroke.css',
		'resetcss'       		=> AUTOMATIC_DIR_URI . '/assets/css/reset-css.css',
		'theme'        			=> AUTOMATIC_DIR_URI . '/assets/css/style.css',
		'shortcode'             => AUTOMATIC_DIR_URI . '/assets/css/shortcode.css',
		'config-color'     		=> AUTOMATIC_DIR_URI . '/assets/css/config-color.css',
		'config-font'        	=> AUTOMATIC_DIR_URI . '/assets/css/config-fonts.css',
		'header'        		=> AUTOMATIC_DIR_URI . '/assets/css/header.css',
		'footer'                => AUTOMATIC_DIR_URI . '/assets/css/footer.css',
		'reponsive'        		=> AUTOMATIC_DIR_URI . '/assets/css/responsive.css',
		'style_custom'          => AUTOMATIC_DIR_URI . '/assets/css/style_custom.css',
		'flexslider'             => AUTOMATIC_DIR_URI . '/assets/css/flexslider.css',
	);
}
function automatic_theme_scripts() {
	return array(
		'jquery'                 	=> AUTOMATIC_DIR_URI . '/assets/js/jquery.js',
		'bootstrap'              	=> AUTOMATIC_DIR_URI . '/assets/js/bootstrap.min.js',
		'ui'                     	=> AUTOMATIC_DIR_URI . '/assets/js/jquery-ui.min.js',
		'countdownTimer'                    => AUTOMATIC_DIR_URI . '/assets/js/jquery.countdownTimer.min.js',
		'plugin'                 	=> AUTOMATIC_DIR_URI . '/assets/js/plugins.js',
		'main'                      => AUTOMATIC_DIR_URI . '/assets/js/jquery.main.js',
		'custom'                  	=> AUTOMATIC_DIR_URI . '/assets/js/custom.js',
		'map'                  		=> AUTOMATIC_DIR_URI . '/assets/js/automatic_map.js',
		'flexslider'                => AUTOMATIC_DIR_URI . '/assets/js/jquery.flexslider-min.js',
		'elevatezoom'               => AUTOMATIC_DIR_URI . '/assets/js/jquery.elevateZoom-3.0.8.min.js',
		'carousel'                  => AUTOMATIC_DIR_URI . '/assets/js/owl.carousel.min.js',
	);
}
function automatic_post_nagivation( $args ) {
    global $post;
    $default = array(
        'post_type_link'    => '',
        'container_class'   => '',
        'prev_link_class'   => '',
        'next_link_class'   => '',
        'prev_link_before'  => '',
        'next_link_after'   => ''
    );

    $args = array_merge( $default, $args );
    if ( '' != $args['prev_link_class'] ) {
        $args['prev_link_class'] = ' class="' . $args['prev_link_class'] . '"';
    }
    if ( '' != $args['next_link_class'] ) {
        $args['next_link_class'] = ' class="' . $args['next_link_class'] . '"';
    }

    // Don't print empty markup if there's nowhere to navigate.
    $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
    $next     = get_adjacent_post( false, '', false );

    if ( ! $next && ! $previous )
        return;
    ?>
    <nav class="navigation post-navigation">
        <div class="nav-links clearfix <?php echo esc_attr($args['container_class']); ?>">
            <?php
            $prev_post = get_previous_post();
            if (!empty( $prev_post )): ?>
              <a <?php echo ($args['prev_link_class']); ?>
                href="<?php echo get_permalink( $prev_post->ID ); ?>"><?php
                    echo ($args['prev_link_before']);?></a>
            <?php endif; ?>
            <a href="<?php echo esc_url($args[ 'post_type_link' ]) ?>" class="dashboard"><i class="fa fa-th-large" aria-hidden="true"></i></a>
            <?php
            $next_post = get_next_post();
            if ( is_a( $next_post , 'WP_Post' ) ) { ?>
              <a <?php echo ($args['next_link_class']); ?>
                href="<?php echo get_permalink( $next_post->ID ); ?>"><?php
                    echo ($args['next_link_after']); ?></a>
            <?php } ?>

            </div><!-- .nav-links -->
    </nav><!-- .navigation -->
    <?php
}
function automatic_get_term_posttype( $post_id, $posttype ) {
        $results = '';
        $terms = get_the_terms( $post_id, $posttype );
        $d=0;
        if ($terms !=''):
			foreach ($terms as $key => $value) {
					# code...
					if ($d != 0){
							$results .= '<a href="' . get_term_link( $value->term_id, $posttype ) . '" >';
							$results .= ', '.$value->name ;
							$results .='</a>';
					}else{
							$results .= '<a href="' . get_term_link( $value->term_id, $posttype ) . '" >';
							$results .= $value->name ;
							$results .='</a>';
					}
					$d++;
			}
        endif;
        return $results;
}

function automatic_loader(){
	$automatic_config = automatic_settings();
	if(isset($automatic_config ['automatic_preload']) && $automatic_config ['automatic_preload'] == 'show'){
		echo '<div class="loaderWrap"> <div id="loader"> <div class="loader-line-mask four"> <div class="loader-line"></div> </div></div> </div>';
	}
}
function automatic_post_comment() {
    if( comments_open() || get_comments_number() ) {
        return true;
    }else{
        return false;
    }
}